close all;

figure
plot(t,f,'LineWidth',2);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('J=f(x,y)','FontSize',18,'FontWeight','bold');
title('Output','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
axis([0 tmax 0.1 1.05]);
%saveas(gcf,'nc_unicycle_output.eps','psc2');
saveas(gcf,'nc_unicycle_output.jpg');


figure
plot(x,y,'LineWidth',2);
hold on
plot(x_sen,y_sen,'r')
xlabel('x','FontSize',18,'FontWeight','bold');
ylabel('y','FontSize',18,'FontWeight','bold');
title('Vehicle Trajectory','FontSize',18,'FontWeight','bold');
legend('Center of Vehicle','Sensor')
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%axis tight
%saveas(gcf,'nc_unicycle_trajectory.eps','psc2');
saveas(gcf,'nc_unicycle_trajectory.jpg');


figure
plot(t,v,'LineWidth',2);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('V','FontSize',18,'FontWeight','bold');
title('Control Input of Forward Velocity before Modulation','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%saveas(gcf,'nc_unicycle_v.eps','psc2');
saveas(gcf,'nc_unicycle_v.jpg');


figure
plot(t,w1*ones(size(t)),'LineWidth',2);
xlabel('time (sec)','FontSize',18,'FontWeight','bold');
ylabel('\omega_0','FontSize',18,'FontWeight','bold');
title('Control Input of Angular Velocity','FontSize',18,'FontWeight','bold');
grid on;  
set(gca,'FontSize',12,'FontWeight','bold'); 
%saveas(gcf,'nc_unicycle_wo.eps','psc2');
saveas(gcf,'nc_unicycle_wo.jpg');

